/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.mixins.common.storage.ChunkLoaderMixin;
import pregenerator.base.mixins.common.storage.IOWorkerMixin;
import pregenerator.base.mixins.common.storage.RegionFileCacheMixin;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.base.ListenerStorage;
import pregenerator.common.base.PregenTaskEvent;
import pregenerator.common.base.ProcessListener;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.DeletionProcessor;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.TaskQueue;
import pregenerator.common.utils.collections.SynchronizedLong2ObjectLinkedOpenHashMap;
import pregenerator.common.utils.misc.AverageCounter;

public class ServerManager {
    public static final ServerManager INSTANCE = new ServerManager();
    public Object2ObjectMap<ResourceKey<Level>, IProcess<?, ?>> processor = new Object2ObjectLinkedOpenHashMap();
    public TaskQueue<ChunkProcess, ITask, ChunkProcessor> generation = new TaskQueue(true, ChunkProcessor.class, (Map<ResourceKey<Level>, IProcess<?, ?>>)this.processor, TaskStorage::getGenStorage);
    TaskQueue<ChunkDeleter, IDeletionTask, DeletionProcessor> deletion = new TaskQueue(false, DeletionProcessor.class, (Map<ResourceKey<Level>, IProcess<?, ?>>)this.processor, TaskStorage::getDeletionStorage);
    Set<ProcessListener> listeners = new ObjectLinkedOpenHashSet();
    AverageCounter memoryAverage = new AverageCounter(600);
    int size;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        int index = (Integer)PregenConfig.INSTANCE.threadingRule.get();
        int cores = Runtime.getRuntime().availableProcessors();
        this.size = index == 0 ? 1 : Math.max(1, index == 1 ? cores / 2 : Math.round((float)cores / 1.5f));
        this.generation.populate(this.size, (Supplier<ChunkProcessor>)((Supplier)ChunkProcessor::new));
        this.deletion.populate(this.size, (Supplier<DeletionProcessor>)((Supplier)DeletionProcessor::new));
    }

    public int getProcessors() {
        return this.size;
    }

    public long getSeed() {
        return this.getServer().m_129880_(Level.f_46428_).m_7328_();
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public boolean hasRetroBlockingTask() {
        for (IProcess process : this.processor.values()) {
            if (!process.isBlockingRetrogen()) continue;
            return true;
        }
        return false;
    }

    public int startTask(IBaseTask<?> task, UUID id, Consumer<Component> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((Component)new TextComponent("Benchmark Running. Can not Run anything else in the meantime"));
            return 0;
        }
        if (ServerLifecycleHooks.getCurrentServer() instanceof DedicatedServer && Runtime.getRuntime().availableProcessors() <= 1 && ((Boolean)PregenConfig.INSTANCE.showDockerWarning.get()).booleanValue()) {
            listener.accept((Component)new TextComponent("It was detected that the JVM can only see a single Core on this Server. This can have serious Performance implications.\nIf you are running this server in a Docker Container please make sure you enable multithreading in it.\nWhich you can by setting the \"--cpuset-cpus=0,1,2\" argument in your Docker Container. Each Number defines which core specific core should be used, though \"--cpuset-cpus=0-3\" can be used for ranges.\nMore info can be found here: https://docs.docker.com/config/containers/resource_constraints/#configure-the-default-cfs-scheduler").m_130940_(ChatFormatting.DARK_RED));
        }
        if (task instanceof ITask) {
            ITask gen = (ITask)task;
            if (!ProcessListener.PREVIEW.getOwner().equals(id)) {
                gen.setOwner(id);
            }
            if (this.generation.startTask(gen, listener, this.getServer())) {
                this.updateListeners(id, true);
            }
        } else if (task instanceof IDeletionTask && this.deletion.startTask((IDeletionTask)task, listener, this.getServer())) {
            this.updateListeners(id, true);
        }
        this.updateAutoRestart();
        return 0;
    }

    public int pauseTask(String taskName, Consumer<Component> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((Component)new TextComponent("Benchmark Running. Pause is disabled"));
            return 0;
        }
        boolean found = false;
        for (IProcess entry : this.processor.values()) {
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName()) || !entry.isRunning()) continue;
            entry.pauseTask();
            found = true;
            listener.accept((Component)new TextComponent("Pausing [" + entry.getTaskName() + "] Task"));
        }
        if (!found) {
            listener.accept((Component)new TextComponent("No Tasks Paused"));
        }
        return 0;
    }

    public int resumeTask(String taskName, Consumer<Component> listener) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            listener.accept((Component)new TextComponent("Benchmark Running. Resume is disabled"));
            return 0;
        }
        boolean found = false;
        for (IProcess entry : this.processor.values()) {
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName()) || entry.isRunning()) continue;
            entry.resumeTask();
            found = true;
            listener.accept((Component)new TextComponent("Resuming [" + entry.getTaskName() + "] Task"));
        }
        if (!found) {
            listener.accept((Component)new TextComponent("No Tasks Resuming"));
        }
        return 0;
    }

    public int stopTask(String taskName, Consumer<Component> listener, boolean interrupt) {
        boolean found = false;
        ObjectIterator iter = this.processor.values().iterator();
        while (iter.hasNext()) {
            IProcess entry = (IProcess)iter.next();
            if (taskName != null && !taskName.equalsIgnoreCase(entry.getTaskName())) continue;
            listener.accept((Component)new TextComponent("Stopping [" + entry.getTaskName() + "] Task"));
            entry.stopTask();
            found = true;
            this.generation.consume(entry);
            this.deletion.consume(entry);
            iter.remove();
        }
        if (!found) {
            listener.accept((Component)new TextComponent("No Tasks Paused"));
        } else {
            this.listeners.clear();
            MinecraftForge.EVENT_BUS.post((Event)new PregenTaskEvent.StoppedAll());
        }
        if (!this.isRunning() && !interrupt) {
            ForgeConfigSpec.BooleanValue value = PregenConfig.INSTANCE.autoRestart;
            value.set((Object)false);
            value.save();
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            BenchmarkManager.INSTANCE.interruptBenchmark();
        }
        return 0;
    }

    public int removeTask(String taskName, Consumer<Component> listener) {
        this.stopTask(taskName, listener, false);
        int total = this.generation.removeTasks(taskName) + this.deletion.removeTasks(taskName);
        listener.accept((Component)new TextComponent((String)(total > 0 ? "Deleted [" + total + "] Tasks" : "No Tasks Deleted")));
        return 0;
    }

    public int continueTask(String name, UUID id, Consumer<Component> listener) {
        if (this.deletion.continueTask(name, listener, this.getServer())) {
            this.updateListeners(id, true);
            this.updateAutoRestart();
        } else if (this.generation.continueTask(name, listener, this.getServer())) {
            this.updateListeners(id, true);
            this.updateAutoRestart();
        }
        return 0;
    }

    public int continueTask(Consumer<Component> listener) {
        this.updateListeners(null, true);
        MinecraftServer server = this.getServer();
        boolean found = true;
        while (this.deletion.findNextTask(listener, server, true)) {
            found = false;
        }
        if (found) {
            while (this.generation.findNextTask(listener, server, true)) {
                found = false;
            }
        }
        this.updateAutoRestart();
        return 0;
    }

    public void onTaskFinished(ResourceKey<Level> type) {
        IProcess entry = (IProcess)this.processor.remove(type);
        if (entry != null) {
            this.generation.consume(entry);
            this.deletion.consume(entry);
        }
        this.updateListeners(null, true);
        Consumer<Component> listener = this::listen;
        MinecraftServer server = this.getServer();
        boolean found = true;
        while (this.deletion.findNextTask(listener, server, true)) {
            found = false;
        }
        if (found) {
            while (this.generation.findNextTask(listener, server, true)) {
                found = false;
            }
        }
        if (found && !this.isRunning()) {
            BenchmarkManager.INSTANCE.onBenchmarksFinished(this::listen);
            this.listeners.clear();
        }
        this.updateAutoRestart();
    }

    public void listen(Component text) {
        MinecraftServer server = this.getServer();
        for (ProcessListener listener : this.listeners) {
            listener.sendMessage(server, text);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (IProcess process : new ObjectArrayList(this.processor.values())) {
                process.onTickStart();
            }
            return;
        }
        int limit = (Integer)PregenConfig.INSTANCE.playerLimit.get();
        boolean paused = limit >= 0 && limit <= ServerLifecycleHooks.getCurrentServer().m_7416_();
        for (IProcess process : new ObjectArrayList(this.processor.values())) {
            process.onTickStop(paused);
        }
        if (!paused && this.processor.size() > 0 && ((Boolean)PregenConfig.INSTANCE.enableMemoryProtector.get()).booleanValue()) {
            this.memoryAverage.addMore(this.freeMemory());
            this.memoryAverage.onFinished();
            if ((Integer)PregenConfig.INSTANCE.requiredFreeMemory.get() > this.memoryAverage.getAverage()) {
                this.stopTask(null, T -> {}, true);
                for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                    boolean save = level.f_8564_;
                    level.f_8564_ = false;
                    level.m_8643_(null, true, false);
                    level.f_8564_ = save;
                }
                ChunkPregenerator.LOGGER.info("Chunk Pregenerators Memory Protector is enabled. (Can be disabled in the config)");
                ChunkPregenerator.LOGGER.info("Free Memory [" + this.memoryAverage.getAverage() + "MB] is below the suggested safe value [" + PregenConfig.INSTANCE.requiredFreeMemory.get() + "MB]");
                ChunkPregenerator.LOGGER.info("This risks World Corruption due to running out of ram.");
                ChunkPregenerator.LOGGER.info("To prevent this a forceful restart is being done!");
                ChunkPregenerator.LOGGER.info("The Worlds and Pregen Progress have been saved!");
                ChunkPregenerator.LOGGER.info("Restarting now!");
                ServerLifecycleHooks.handleExit((int)0);
            }
        }
    }

    public byte[] sendData() {
        if (this.processor.isEmpty()) {
            return new byte[0];
        }
        ByteBuf buf = Unpooled.buffer();
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        buffer.writeInt(this.processor.size());
        for (Object2ObjectMap.Entry entry : this.processor.object2ObjectEntrySet()) {
            buffer.m_130085_(((ResourceKey)entry.getKey()).m_135782_());
            ((IProcess)entry.getValue()).sendClientData(buffer);
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        return data;
    }

    public void addListener(UUID id) {
        this.listeners.add(ProcessListener.create(id));
    }

    public void updateListeners(UUID id, boolean triggerAuto) {
        ListenerStorage storage = TaskStorage.getListeners();
        if (!storage.isIgnoring(id)) {
            this.listeners.add(ProcessListener.create(id));
        }
        if (triggerAuto) {
            TaskStorage.getListeners().updateListeners(this.listeners);
        }
    }

    public void removeListener(UUID id) {
        this.listeners.remove(ProcessListener.create(id));
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.removeListener(event.getEntity().m_142081_());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        UUID id = event.getEntity().m_142081_();
        if (this.getServer().m_129792_() && !TaskStorage.getListeners().contains(id)) {
            TaskStorage.getListeners().add(id, (Boolean)PregenConfig.INSTANCE.pregenOverlay.get() == false);
        }
        if (TaskStorage.getListeners().isAutoListening(id)) {
            this.listeners.add(ProcessListener.create(id));
        }
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppingEvent event) {
        this.stopTask(null, T -> {}, true);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartingEvent event) {
        if (!TaskStorage.getListeners().contains(null)) {
            TaskStorage.getListeners().add(null, true);
        }
        if (((Boolean)PregenConfig.INSTANCE.autoRestart.get()).booleanValue()) {
            this.onTaskFinished(null);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (world instanceof ServerLevel) {
            try {
                RegionFileCacheMixin mixin = (RegionFileCacheMixin)((IOWorkerMixin)((ChunkLoaderMixin)((ServerLevel)world).m_7726_().f_8325_).getWorker()).getStorage();
                Long2ObjectLinkedOpenHashMap<RegionFile> cache = mixin.getRegionCache();
                mixin.setRegionCache(new SynchronizedLong2ObjectLinkedOpenHashMap<RegionFile>((Map<Long, RegionFile>)cache));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateAutoRestart() {
        ForgeConfigSpec.BooleanValue value = PregenConfig.INSTANCE.autoRestart;
        if (((Boolean)value.get()).booleanValue() != this.isRunning()) {
            value.set((Object)this.isRunning());
            value.save();
        }
    }

    public boolean hasProcessorsLeft() {
        return !this.generation.isEmpty();
    }

    public boolean isRunning() {
        return this.processor.size() > 0;
    }

    public boolean isRunning(ResourceKey<Level> type) {
        return this.processor.get(type) != null;
    }

    public long[] getData(ResourceKey<Level> target) {
        long[] data = new long[6];
        for (IProcess entry : this.processor.values()) {
            if (!(entry instanceof ChunkProcessor)) continue;
            ChunkProcessor process = (ChunkProcessor)entry;
            data[0] = data[0] + process.getTotal();
            data[1] = data[1] + process.getGenDone();
            data[2] = data[2] + process.getLightDone();
        }
        IProcess entry = (IProcess)this.processor.get(target);
        if (entry instanceof ChunkProcessor) {
            ChunkProcessor process = (ChunkProcessor)entry;
            data[3] = data[3] + process.getTotal();
            data[4] = data[4] + process.getGenDone();
            data[5] = data[5] + process.getLightDone();
        }
        return data;
    }

    public boolean isListening(UUID id) {
        return this.listeners.contains(ProcessListener.create(id));
    }

    int freeMemory() {
        Runtime rn = Runtime.getRuntime();
        return (int)(rn.maxMemory() - rn.totalMemory() + rn.freeMemory() >> 20);
    }
}

